﻿using System;
using Soneta.Kasa;

namespace ASP
{
    public partial class Przelew_Graficzny : System.Web.UI.Page {
        public string Str_Exc_BrakNrRachunkuZus = "Brak numeru rachunku ZUS, na który następuje wpłata.";
        public string Str_Exc_NiewlasciwyWzorzec = "Ten wzorzec wydruku nie może być użyty do drukowania przelewów typu '{0}'.";

        //---------
        protected void OnContextLoad(object sender, EventArgs args)
        {
            PrzelewBase przelew = (PrzelewBase)dc[typeof(PrzelewBase)];
            if (przelew.Typ2 == TypPrzelewu2.PrzelewMPP)
            {
                var przelewMpp = (Przelew)przelew;
                var lines = MppTools.ReportTitle(przelewMpp.MPP);
                P1T1.EditValue = P2T1.EditValue = lines[0];
                P1T2.EditValue = P2T2.EditValue = lines[1];
            }
            else
            {
                P1T1.EditValue = P2T1.EditValue = przelew.Tytulem1;
                P1T2.EditValue = P2T2.EditValue = przelew.Tytulem2;
            }

            switch (przelew.Typ)
            {
                case TypPrzelewu.Standardowy:

                    SectionStandard.Visible = true;
                    break;

                case TypPrzelewu.PrzelewPIT:

                    SectionPIT.Visible = true;
                    UsTypId.EditValue = UsTypId2.EditValue = Soneta.Core.Tools.Left(przelew.US.TypIdentyfikatoraS, 1);
                    UsYear.EditValue = UsYear2.EditValue = przelew.US.Rok.ToString("0000").Substring(2);
                    UsTypOkres.EditValue = UsTypOkres2.EditValue = Soneta.Core.Tools.Left(przelew.US.TypOkresuS, 1);
                    break;

                case TypPrzelewu.PrzelewZUS:

                    SectionZUS.Visible = true;

                    String rachunekOdbiorcyElixir = przelew.RachunekOdbiorcy.ToElixir();
                    if (rachunekOdbiorcyElixir == null || rachunekOdbiorcyElixir.Length < 20)
                        throw new ApplicationException(Str_Exc_BrakNrRachunkuZus);

                    String rachPrefix = rachunekOdbiorcyElixir[0] + "&nbsp;&nbsp;&nbsp;" + rachunekOdbiorcyElixir[1];

                    ZusRach1.EditValue = ZusRach3.EditValue = rachPrefix;
                    ZusRach2.EditValue = ZusRach4.EditValue = przelew.RachunekOdbiorcy.ToElixir().Substring(20, 1);
                    ZusIdxTyp.EditValue = ZusIdxTyp2.EditValue = przelew.ZUS.TypIdentyfikatoraS.Substring(0, 1);
                    ZusIdx.EditValue = ZusIdx2.EditValue = przelew.ZUS.Identyfikator;
                    ZusTypWpl.EditValue = ZusTypWpl2.EditValue = Soneta.Core.Tools.Left(przelew.ZUS.TypWpłatyS, 1);
                    ZusDeklaracja1.EditValue = ZusDeklaracja1C.EditValue = przelew.ZUS.Deklaracja.ToString("000000").Substring(4, 2);
                    ZusDeklaracja2.EditValue = ZusDeklaracja2C.EditValue = przelew.ZUS.Deklaracja.ToString("000000").Substring(0, 4);
                    break;

                default:
                    throw new ApplicationException(String.Format(Str_Exc_NiewlasciwyWzorzec, przelew.Typ));
            }
        }
    }
}
